# check_watermark.ps1

$vlcrc = Join-Path $env:APPDATA 'vlc\vlcrc'
if ( -not (Test-Path $vlcrc) ) {
    Write-Host "[ERROR] VLC config file not found: $vlcrc"
    exit 1
}

$lines = Get-Content $vlcrc

$logoFileLine = $lines | Where-Object { $_ -match '^logo-file=(.+)$' }
$xLine        = $lines | Where-Object { $_ -match '^logo-x=(\d+)$' }
$yLine        = $lines | Where-Object { $_ -match '^logo-y=(\d+)$' }

if (-not $logoFileLine) {
    Write-Host "[FAIL] logo-file not found."
    exit 1
}
if (-not $xLine) {
    Write-Host "[FAIL] logo-x not found."
    exit 1
}
if (-not $yLine) {
    Write-Host "[FAIL] logo-y not found."
    exit 1
}

$logoPath = $logoFileLine -replace '^logo-file=', ''
$xValue   = [int]($xLine -replace '^logo-x=', '')
$yValue   = [int]($yLine -replace '^logo-y=', '')

$xOk = $xValue -ge 778
$yOk = $yValue -ge 585

$pathOk = $logoPath -match 'vlcmediaplayer_09\\watermark\.png$'

if ($xOk -and $yOk -and $pathOk) {
    Write-Host "[SUCCESS] Watermark position and path are correctly configured."
    exit 0
}
else {
    Write-Host "[FAIL] One or more settings are incorrect."
    Write-Host "       logo-x: $xValue (expected >= 778)"
    Write-Host "       logo-y: $yValue (expected >= 585)"
    Write-Host "       logo-file: $logoPath (expected to end with vlcmediaplayer_09\watermark.png)"
    exit 1
}
