$regPath = 'HKCU:\Software\Microsoft\Lighting'
$keyName = 'Brightness'
$expected = 70

if (-not (Test-Path $regPath)) {
    Write-Host "[FAIL] Dynamic Lighting registry path not found."
    exit 1
}

try {
    $value = Get-ItemPropertyValue -Path $regPath -Name $keyName -ErrorAction Stop
} catch {
    Write-Host "[FAIL] Brightness key not found."
    exit 1
}

if ($value -eq $expected) {
    Write-Host "[SUCCESS] Dynamic Lighting brightness is set to $expected%."
} else {
    Write-Host "[FAIL] Brightness is $value%, expected $expected%."
}
