$regPath = "HKCU:\Software\Microsoft\Windows\CurrentVersion\Themes\Personalize"

try {
    $lightTheme = (Get-ItemProperty -Path $regPath -Name "SystemUsesLightTheme").SystemUsesLightTheme

    if ($lightTheme -eq 0) {
        Write-Host "[SUCCESS] Windows is set to Dark mode."
    } elseif ($lightTheme -eq 1) {
        Write-Host "[FAIL] Windows is in Light mode."
    } else {
        Write-Host "[FAIL] Unexpected value: SystemUsesLightTheme = $lightTheme"
    }
} catch {
    Write-Host "[FAIL] Could not read Windows theme setting."
}
