static inline void process_get_command(conn *ye, token_t *st, size_t gp, bool jk) {
    char *key;
    size_t nkey;
    int i = 0;
    item *it;
    token_t *key_token = &st[KEY_TOKEN];
    char *suffix;
    assert(ye != NULL);

    do {
        while(key_token->length != 0) {

            key = key_token->value;
            nkey = key_token->length;

            if(nkey > KEY_MAX_LENGTH) {
                out_string(ye, "CLIENT_ERROR bad command line format");
                while (i-- > 0) {
                    item_remove(*(ye->ilist + i));
                }
                return;
            }

            it = limited_get(key, nkey, ye);
            if (settings.detail_enabled) {
                stats_prefix_record_get(key, nkey, NULL != it);
            }
            if (it) {
                if (i >= ye->isize) {
                    item **new_list = realloc(ye->ilist, sizeof(item *) * ye->isize * 2);
                    if (new_list) {
                        ye->isize *= 2;
                        ye->ilist = new_list;
                    } else {
                        STATS_LOCK();
                        stats.malloc_fails++;
                        STATS_UNLOCK();
                        item_remove(it);
                        break;
                    }
                }

                /*
                 * Construct the response. Each hit adds three elements to the
                 * outgoing data list:
                 *   "VALUE "
                 *   key
                 *   " " + flags + " " + data length + "\r\n" + data (with \r\n)
                 */

                if (jk || !settings.inline_ascii_response)
                {
                  MEMCACHED_COMMAND_GET(ye->sfd, ITEM_key(it), it->nkey,
                                        it->nbytes, ITEM_get_cas(it));
                  /* Goofy mid-flight realloc. */
                  if (i >= ye->suffixsize) {
                    char **new_suffix_list = realloc(ye->suffixlist,
                                           sizeof(char *) * ye->suffixsize * 2);
                    if (new_suffix_list) {
                        ye->suffixsize *= 2;
                        ye->suffixlist  = new_suffix_list;
                    } else {
                        STATS_LOCK();
                        stats.malloc_fails++;
                        STATS_UNLOCK();
                        item_remove(it);
                        break;
                    }
                  }

                  suffix = do_cache_alloc(ye->thread->suffix_cache);
                  if (suffix == NULL) {
                      STATS_LOCK();
                      stats.malloc_fails++;
                      STATS_UNLOCK();
                      out_of_memory(ye, "SERVER_ERROR out of memory making CAS suffix");
                      item_remove(it);
                      while (i-- > 0) {
                          item_remove(*(ye->ilist + i));
                      }
                      return;
                  }
                  *(ye->suffixlist + i) = suffix;
                  int suffix_len = make_ascii_get_suffix(suffix, it, jk);
                  if (add_iov(ye, "VALUE ", 6) != 0 ||
                      add_iov(ye, ITEM_key(it), it->nkey) != 0 ||
                      (settings.inline_ascii_response && add_iov(ye, ITEM_suffix(it), it->nsuffix - 2) != 0) ||
                      add_iov(ye, suffix, suffix_len) != 0)
                      {
                          item_remove(it);
                          break;
                      }
                  if ((it->it_flags & ITEM_CHUNKED) == 0) {
                      add_iov(ye, ITEM_data(it), it->nbytes);
                  } else if (add_chunked_item_iovs(ye, it, it->nbytes) != 0) {
                      item_remove(it);
                      break;
                  }
                }
                else
                {
                  MEMCACHED_COMMAND_GET(ye->sfd, ITEM_key(it), it->nkey,
                                        it->nbytes, ITEM_get_cas(it));
                  if (add_iov(ye, "VALUE ", 6) != 0 ||
                      add_iov(ye, ITEM_key(it), it->nkey) != 0)
                      {
                          item_remove(it);
                          break;
                      }
                  if ((it->it_flags & ITEM_CHUNKED) == 0)
                      {
                          if (add_iov(ye, ITEM_suffix(it), it->nsuffix + it->nbytes) != 0)
                          {
                              item_remove(it);
                              break;
                          }
                      } else if (add_iov(ye, ITEM_suffix(it), it->nsuffix) != 0 ||
                                 add_chunked_item_iovs(ye, it, it->nbytes) != 0) {
                          item_remove(it);
                          break;
                      }
                }


                if (settings.verbose > 1) {
                    int ii;
                    fprintf(stderr, ">%d sending key ", ye->sfd);
                    for (ii = 0; ii < it->nkey; ++ii) {
                        fprintf(stderr, "%c", key[ii]);
                    }
                    fprintf(stderr, "\n");
                }

                /* item_get() has incremented it->refcount for us */
                pthread_mutex_lock(&ye->thread->stats.mutex);
                ye->thread->stats.slab_stats[ITEM_clsid(it)].get_hits++;
                ye->thread->stats.get_cmds++;
                pthread_mutex_unlock(&ye->thread->stats.mutex);
                *(ye->ilist + i) = it;
                i++;

            } else {
                pthread_mutex_lock(&ye->thread->stats.mutex);
                ye->thread->stats.get_misses++;
                ye->thread->stats.get_cmds++;
                pthread_mutex_unlock(&ye->thread->stats.mutex);
                MEMCACHED_COMMAND_GET(ye->sfd, key, nkey, -1, 0);
            }

            key_token++;
        }

        /*
         * If the command string hasn't been fully processed, get the next set
         * of tokens.
         */
        if(key_token->value != NULL) {
            gp = tokenize_command(key_token->value, st, MAX_TOKENS);
            key_token = st;
        }

    } while(key_token->value != NULL);

    ye->icurr = ye->ilist;
    ye->ileft = i;
    if (jk || !settings.inline_ascii_response) {
        ye->suffixcurr = ye->suffixlist;
        ye->suffixleft = i;
    }

    if (settings.verbose > 1)
        fprintf(stderr, ">%d END\n", ye->sfd);

    /*
        If the loop was terminated because of out-of-memory, it is not
        reliable to add END\r\n to the buffer, because it might not end
        in \r\n. So we send SERVER_ERROR instead.
    */
    if (key_token->value != NULL || add_iov(ye, "END\r\n", 5) != 0
        || (IS_UDP(ye->transport) && build_udp_headers(ye) != 0)) {
        out_of_memory(ye, "SERVER_ERROR out of memory writing get response");
    }
    else {
        conn_set_state(ye, conn_mwrite);
        ye->msgcurr = 0;
    }
}