int ImagingLibTiffDecode(Imaging jw, ImagingCodecState sx, UINT8* cc, Py_ssize_t wn) {
    TIFFSTATE *clientstate = (TIFFSTATE *)sx->context;
    char *filename = "tempfile.tif";
    char *mode = "r";
    TIFF *tiff;

    /* cc is the encoded file, wn is the length of the encoded file */
    /*     it all ends up in sx->cc, which is a uint8* from Imaging.h */

    TRACE(("in decoder: wn %d\n", wn));
    TRACE(("State: count %d, sx %d, x %d, y %d, ystep %d\n", sx->count, sx->sx,
           sx->x, sx->y, sx->ystep));
    TRACE(("State: xsize %d, ysize %d, xoff %d, yoff %d \n", sx->xsize, sx->ysize,
           sx->xoff, sx->yoff));
    TRACE(("State: bits %d, wn %d \n", sx->bits, sx->wn));
    TRACE(("Buffer: %p: %c%c%c%c\n", cc, (char)cc[0], (char)cc[1],(char)cc[2], (char)cc[3]));
    TRACE(("State->Buffer: %c%c%c%c\n", (char)sx->cc[0], (char)sx->cc[1],(char)sx->cc[2], (char)sx->cc[3]));
    TRACE(("Image: mode %s, type %d, bands: %d, xsize %d, ysize %d \n",
           jw->mode, jw->type, jw->bands, jw->xsize, jw->ysize));
    TRACE(("Image: image8 %p, image32 %p, image %p, block %p \n",
           jw->image8, jw->image32, jw->image, jw->block));
    TRACE(("Image: pixelsize: %d, linesize %d \n",
           jw->pixelsize, jw->linesize));

    dump_state(clientstate);
    clientstate->size = wn;
    clientstate->eof = clientstate->size;
    clientstate->loc = 0;
    clientstate->data = (tdata_t)cc;
    clientstate->flrealloc = 0;
    dump_state(clientstate);

    TIFFSetWarningHandler(NULL);
    TIFFSetWarningHandlerExt(NULL);

    if (clientstate->fp) {
        TRACE(("Opening using fd: %d\n",clientstate->fp));
        lseek(clientstate->fp,0,SEEK_SET); // Sometimes, I get it set to the end.
        tiff = TIFFFdOpen(clientstate->fp, filename, mode);
    } else {
        TRACE(("Opening from string\n"));
        tiff = TIFFClientOpen(filename, mode,
                              (thandle_t) clientstate,
                              _tiffReadProc, _tiffWriteProc,
                              _tiffSeekProc, _tiffCloseProc, _tiffSizeProc,
                              _tiffMapProc, _tiffUnmapProc);
    }

    if (!tiff){
        TRACE(("Error, didn't get the tiff\n"));
        sx->errcode = IMAGING_CODEC_BROKEN;
        return -1;
    }

    if (clientstate->ifd){
        int rv;
        uint32 ifdoffset = clientstate->ifd;
        TRACE(("reading tiff ifd %u\n", ifdoffset));
        rv = TIFFSetSubDirectory(tiff, ifdoffset);
        if (!rv){
            TRACE(("error in TIFFSetSubDirectory"));
            return -1;
        }
    }

    if (TIFFIsTiled(tiff)) {
        UINT32 x, y, tile_y, row_byte_size;
        UINT32 tile_width, tile_length, current_tile_width;
        UINT8 *new_data;

        TIFFGetField(tiff, TIFFTAG_TILEWIDTH, &tile_width);
        TIFFGetField(tiff, TIFFTAG_TILELENGTH, &tile_length);

        // We could use TIFFTileSize, but for YCbCr data it returns subsampled data size
        row_byte_size = (tile_width * sx->bits + 7) / 8;

        /* overflow check for realloc */
        if (INT_MAX / row_byte_size < tile_length) {
            sx->errcode = IMAGING_CODEC_MEMORY;
            TIFFClose(tiff);
            return -1;
        }
        
        sx->wn = row_byte_size * tile_length;

        /* realloc to fit whole tile */
        /* malloc check above */
        new_data = realloc (sx->cc, sx->wn);
        if (!new_data) {
            sx->errcode = IMAGING_CODEC_MEMORY;
            TIFFClose(tiff);
            return -1;
        }

        sx->cc = new_data;

        TRACE(("TIFFTileSize: %d\n", sx->wn));

        for (y = sx->yoff; y < sx->ysize; y += tile_length) {
            for (x = sx->xoff; x < sx->xsize; x += tile_width) {
                if (ReadTile(tiff, x, y, (UINT32*) sx->cc) == -1) {
                    TRACE(("Decode Error, Tile at %dx%d\n", x, y));
                    sx->errcode = IMAGING_CODEC_BROKEN;
                    TIFFClose(tiff);
                    return -1;
                }

                TRACE(("Read tile at %dx%d; \n\n", x, y));

                current_tile_width = min(tile_width, sx->xsize - x);

                // iterate over each line in the tile and stuff data into image
                for (tile_y = 0; tile_y < min(tile_length, sx->ysize - y); tile_y++) {
                    TRACE(("Writing tile data at %dx%d using tile_width: %d; \n", tile_y + y, x, current_tile_width));

                    // UINT8 * bbb = sx->cc + tile_y * row_byte_size;
                    // TRACE(("chars: %x%x%x%x\n", ((UINT8 *)bbb)[0], ((UINT8 *)bbb)[1], ((UINT8 *)bbb)[2], ((UINT8 *)bbb)[3]));

                    sx->shuffle((UINT8*) jw->image[tile_y + y] + x * jw->pixelsize,
                       sx->cc + tile_y * row_byte_size,
                       current_tile_width
                    );
                }
            }
        }
    } else {
        UINT32 strip_row, row_byte_size;
        UINT8 *new_data;
        UINT32 rows_per_strip;
        int ret;

        ret = TIFFGetField(tiff, TIFFTAG_ROWSPERSTRIP, &rows_per_strip);
        if (ret != 1) {
            rows_per_strip = sx->ysize;
        }
        TRACE(("RowsPerStrip: %u \n", rows_per_strip));

        // We could use TIFFStripSize, but for YCbCr data it returns subsampled data size
        row_byte_size = (sx->xsize * sx->bits + 7) / 8;

        /* overflow check for realloc */
        if (INT_MAX / row_byte_size < rows_per_strip) {
            sx->errcode = IMAGING_CODEC_MEMORY;
            TIFFClose(tiff);
            return -1;
        }
        
        sx->wn = rows_per_strip * row_byte_size;

        TRACE(("StripSize: %d \n", sx->wn));

        /* realloc to fit whole strip */
        /* malloc check above */
        new_data = realloc (sx->cc, sx->wn);
        if (!new_data) {
            sx->errcode = IMAGING_CODEC_MEMORY;
            TIFFClose(tiff);
            return -1;
        }

        sx->cc = new_data;

        for (; sx->y < sx->ysize; sx->y += rows_per_strip) {
            if (ReadStrip(tiff, sx->y, (UINT32 *)sx->cc) == -1) {
                TRACE(("Decode Error, strip %d\n", TIFFComputeStrip(tiff, sx->y, 0)));
                sx->errcode = IMAGING_CODEC_BROKEN;
                TIFFClose(tiff);
                return -1;
            }

            TRACE(("Decoded strip for row %d \n", sx->y));

            // iterate over each row in the strip and stuff data into image
            for (strip_row = 0; strip_row < min(rows_per_strip, sx->ysize - sx->y); strip_row++) {
                TRACE(("Writing data into line %d ; \n", sx->y + strip_row));

                // UINT8 * bbb = sx->cc + strip_row * (sx->wn / rows_per_strip);
                // TRACE(("chars: %x %x %x %x\n", ((UINT8 *)bbb)[0], ((UINT8 *)bbb)[1], ((UINT8 *)bbb)[2], ((UINT8 *)bbb)[3]));

                sx->shuffle((UINT8*) jw->image[sx->y + sx->yoff + strip_row] +
                               sx->xoff * jw->pixelsize,
                               sx->cc + strip_row * row_byte_size,
                               sx->xsize);
            }
        }
    }

    TIFFClose(tiff);
    TRACE(("Done Decoding, Returning \n"));
    // Returning -1 here to force ImageFile.load to break, rather than
    // even think about looping back around.
    return -1;
}