//GEMINI-pro DATASET v1.0 Category: Interprocess communication ; Style: medieval
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <string.h>

#define MSGKEY 1234

typedef struct {
    long mtype;
    char mtext[512];
} message_t;

int main(int argc, char *argv[])
{
    int msqid;
    message_t msg;
    key_t key;

    // Create the message queue.
    key = ftok(".", MSGKEY);
    msqid = msgget(key, 0666 | IPC_CREAT);
    if (msqid == -1) {
        perror("msgget");
        exit(1);
    }

    // Send a message to the queue.
    msg.mtype = 1;
    strcpy(msg.mtext, "Hark! I bring tidings from the far-off land of Mordor!");
    if (msgsnd(msqid, &msg, sizeof(msg.mtext), 0) == -1) {
        perror("msgsnd");
        exit(1);
    }

    // Receive a message from the queue.
    if (msgrcv(msqid, &msg, sizeof(msg.mtext), 0, 0) == -1) {
        perror("msgrcv");
        exit(1);
    }

    // Print the message.
    printf("Message received: %s\n", msg.mtext);

    // Delete the message queue.
    if (msgctl(msqid, IPC_RMID, NULL) == -1) {
        perror("msgctl");
        exit(1);
    }

    return 0;
}