//Falcon-180B DATASET v1.0 Category: Threading Library Implementation ; Style: medieval
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#define NUM_THREADS 5

typedef struct {
    int id;
    char *name;
} thread_data_t;

void *thread_func(void *arg) {
    thread_data_t *data = (thread_data_t *) arg;

    printf("Thread %d: %s reporting for duty!\n", data->id, data->name);

    return NULL;
}

int main() {
    pthread_t threads[NUM_THREADS];
    thread_data_t data[NUM_THREADS] = {
        {1, "Sir William"},
        {2, "Lady Isabella"},
        {3, "Sir Richard"},
        {4, "Lady Anne"},
        {5, "Sir Thomas"}
    };

    int rc;
    for (int i = 0; i < NUM_THREADS; ++i) {
        rc = pthread_create(&threads[i], NULL, thread_func, &data[i]);
        if (rc) {
            printf("Error: unable to create thread %d, %s\n", i + 1, strerror(rc));
            exit(1);
        }
    }

    for (int i = 0; i < NUM_THREADS; ++i) {
        rc = pthread_join(threads[i], NULL);
        if (rc) {
            printf("Error: unable to join thread %d, %s\n", i + 1, strerror(rc));
            exit(1);
        }
    }

    printf("All threads have returned from their duties.\n");

    return 0;
}