//GPT-4o-mini DATASET v1.0 Category: Network Topology Mapper ; Style: immersive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_DEVICES 100
#define MAX_NAME_LEN 50

typedef struct {
    char name[MAX_NAME_LEN];
    int connectionCount;
    int connections[MAX_DEVICES];
} Device;

typedef struct {
    Device devices[MAX_DEVICES];
    int deviceCount;
} Network;

void addDevice(Network* network, const char* deviceName) {
    if (network->deviceCount >= MAX_DEVICES) {
        printf("Maximum device limit reached.\n");
        return;
    }
    
    strncpy(network->devices[network->deviceCount].name, deviceName, MAX_NAME_LEN - 1);
    network->devices[network->deviceCount].connectionCount = 0;
    network->deviceCount++;
    
    printf("Device %s added successfully!\n", deviceName);
}

void connectDevices(Network* network, int deviceIndex1, int deviceIndex2) {
    if (deviceIndex1 >= network->deviceCount || deviceIndex2 >= network->deviceCount) {
        printf("Invalid device index.\n");
        return;
    }
    
    if (network->devices[deviceIndex1].connectionCount >= MAX_DEVICES ||
        network->devices[deviceIndex2].connectionCount >= MAX_DEVICES) {
        printf("Connection limit reached for one of the devices.\n");
        return;
    }
    
    // Add connection in both directions
    network->devices[deviceIndex1].connections[network->devices[deviceIndex1].connectionCount++] = deviceIndex2;
    network->devices[deviceIndex2].connections[network->devices[deviceIndex2].connectionCount++] = deviceIndex1;
    
    printf("Connected %s and %s.\n", network->devices[deviceIndex1].name, network->devices[deviceIndex2].name);
}

void displayTopology(const Network* network) {
    printf("\n--- Network Topology ---\n");
    
    for (int i = 0; i < network->deviceCount; i++) {
        printf("Device: %s", network->devices[i].name);
        if (network->devices[i].connectionCount > 0) {
            printf(" | Connections: ");
            for (int j = 0; j < network->devices[i].connectionCount; j++) {
                printf("%s", network->devices[network->devices[i].connections[j]].name);
                if (j < network->devices[i].connectionCount - 1) {
                    printf(", ");
                }
            }
        }
        printf("\n");
    }
}

int main() {
    Network myNetwork = { .deviceCount = 0 };

    addDevice(&myNetwork, "Router");
    addDevice(&myNetwork, "Switch1");
    addDevice(&myNetwork, "PC1");
    addDevice(&myNetwork, "Printer");
    addDevice(&myNetwork, "Switch2");
    addDevice(&myNetwork, "PC2");

    connectDevices(&myNetwork, 0, 1); // Router <-> Switch1
    connectDevices(&myNetwork, 1, 2); // Switch1 <-> PC1
    connectDevices(&myNetwork, 1, 3); // Switch1 <-> Printer
    connectDevices(&myNetwork, 1, 4); // Switch1 <-> Switch2
    connectDevices(&myNetwork, 4, 5); // Switch2 <-> PC2

    displayTopology(&myNetwork);

    return 0;
}