//GEMINI-pro DATASET v1.0 Category: Error handling ; Style: systematic
#include <stdio.h>
#include <stdlib.h>

// Custom error codes
enum errors {
    ERR_SUCCESS = 0,
    ERR_INVALID_INPUT = 1,
    ERR_FILE_NOT_FOUND = 2,
    ERR_MEMORY_ALLOCATION_FAILED = 3,
    ERR_UNKNOWN = 99
};

// Custom error handling function
void handle_error(int error_code) {
    switch (error_code) {
        case ERR_SUCCESS:
            printf("No error occurred.\n");
            break;
        case ERR_INVALID_INPUT:
            printf("Invalid input was provided.\n");
            break;
        case ERR_FILE_NOT_FOUND:
            printf("Specified file could not be found.\n");
            break;
        case ERR_MEMORY_ALLOCATION_FAILED:
            printf("Memory allocation failed.\n");
            break;
        case ERR_UNKNOWN:
        default:
            printf("An unknown error occurred.\n");
    }
}

int main() {
    // Simulate a potential error by accessing an array out of bounds
    int array[5];
    int index = 10;

    // Attempt to access the array element at the specified index
    if (index >= 0 && index < 5) {
        printf("Element at index %d: %d\n", index, array[index]);
    } else {
        // Handle the error: Invalid index
        handle_error(ERR_INVALID_INPUT);
        return ERR_INVALID_INPUT;
    }

    // Simulate a potential memory allocation failure
    int *ptr = NULL;
    ptr = (int *)malloc(sizeof(int) * 1000000000); // Request a large amount of memory
    if (ptr != NULL) {
        // Successfully allocated memory
        printf("Memory allocated successfully.\n");
        free(ptr); // Release the allocated memory
    } else {
        // Handle the error: Memory allocation failed
        handle_error(ERR_MEMORY_ALLOCATION_FAILED);
        return ERR_MEMORY_ALLOCATION_FAILED;
    }

    return ERR_SUCCESS;
}