//Gemma-7B DATASET v1.0 Category: Simulation of the Solar System ; Style: mathematical
#include <stdio.h>
#include <math.h>

#define G 6.674e-11

typedef struct celestial_body {
    char name[20];
    double mass;
    double x;
    double y;
    double z;
    double vx;
    double vy;
    double vz;
} celestial_body;

int main() {
    // Define the celestial bodies
    celestial_body sun = {"Sun", 1.98e30, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    celestial_body earth = {"Earth", 5.97e24, 1.52e11, 0.0, 0.0, 0.0, 0.0, 0.0};
    celestial_body mars = {"Mars", 0.64e24, 2.28e11, 0.0, 0.0, 0.0, 0.0, 0.0};
    celestial_body mercury = {"Mercury", 0.055e24, 5.90e10, 0.0, 0.0, 0.0, 0.0, 0.0};

    // Calculate the gravitational force between each pair of bodies
    double force_earth_sun = G * earth.mass * sun.mass / (earth.x - sun.x) * (earth.y - sun.y) * (earth.z - sun.z);
    double force_mars_sun = G * mars.mass * sun.mass / (mars.x - sun.x) * (mars.y - sun.y) * (mars.z - sun.z);
    double force_mercury_sun = G * mercury.mass * sun.mass / (mercury.x - sun.x) * (mercury.y - sun.y) * (mercury.z - sun.z);

    // Calculate the acceleration of each body due to the force
    double acceleration_earth_sun = force_earth_sun / earth.mass;
    double acceleration_mars_sun = force_mars_sun / mars.mass;
    double acceleration_mercury_sun = force_mercury_sun / mercury.mass;

    // Update the positions and velocities of the bodies
    earth.vx += acceleration_earth_sun * 0.1;
    earth.vy += acceleration_earth_sun * 0.1;
    earth.vz += acceleration_earth_sun * 0.1;

    mars.vx += acceleration_mars_sun * 0.1;
    mars.vy += acceleration_mars_sun * 0.1;
    mars.vz += acceleration_mars_sun * 0.1;

    mercury.vx += acceleration_mercury_sun * 0.1;
    mercury.vy += acceleration_mercury_sun * 0.1;
    mercury.vz += acceleration_mercury_sun * 0.1;

    // Print the positions and velocities of the bodies
    printf("Position of Earth: (%f, %f, %f)\n", earth.x, earth.y, earth.z);
    printf("Velocity of Earth: (%f, %f, %f)\n", earth.vx, earth.vy, earth.vz);

    printf("Position of Mars: (%f, %f, %f)\n", mars.x, mars.y, mars.z);
    printf("Velocity of Mars: (%f, %f, %f)\n", mars.vx, mars.vy, mars.vz);

    printf("Position of Mercury: (%f, %f, %f)\n", mercury.x, mercury.y, mercury.z);
    printf("Velocity of Mercury: (%f, %f, %f)\n", mercury.vx, mercury.vy, mercury.vz);

    return 0;
}