//MISTRAL-7B DATASET v1.0 Category: Secure Password Generator ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define PASSWORD_LENGTH 12
#define CHAR_COUNT 4
#define LOWER_CASE_CHARS "abcdefghijklmnopqrstuvwxyz"
#define UPPER_CASE_CHARS "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
#define DIGITS_CHARS "0123456789"
#define SPECIAL_CHARS "!@#$%^&*()_+-={}[]|\\:;\"'<>,.?/~`"

int main() {
    int password_length = PASSWORD_LENGTH;
    int char_count = CHAR_COUNT;

    char *password = (char *)malloc(password_length + 1);
    if (password == NULL) {
        fprintf(stderr, "Memory allocation failed.\n");
        return 1;
    }

    srand(time(NULL));

    int lower_case_count = password_length / CHAR_COUNT;
    int upper_case_count = password_length / CHAR_COUNT;
    int digits_count = password_length / CHAR_COUNT;
    int special_chars_count = password_length % CHAR_COUNT;

    for (int i = 0; i < lower_case_count; i++) {
        password[i] = LOWER_CASE_CHARS[rand() % (sizeof(LOWER_CASE_CHARS) - 1)];
    }

    for (int i = lower_case_count; i < (lower_case_count + upper_case_count); i++) {
        password[i] = UPPER_CASE_CHARS[rand() % (sizeof(UPPER_CASE_CHARS) - 1)];
    }

    for (int i = (lower_case_count + upper_case_count); i < (lower_case_count + upper_case_count + digits_count); i++) {
        password[i] = DIGITS_CHARS[rand() % (sizeof(DIGITS_CHARS) - 1)];
    }

    for (int i = (lower_case_count + upper_case_count + digits_count); i < password_length; i++) {
        password[i] = SPECIAL_CHARS[rand() % (sizeof(SPECIAL_CHARS) - 1)];
    }

    password[password_length] = '\0';

    printf("Generated Password: %s\n", password);

    free(password);

    return 0;
}