//Falcon-180B DATASET v1.0 Category: Recursive ; Style: mind-bending
#include <stdio.h>
#include <stdlib.h>

// Function to print a string in reverse order
void reverseString(char* str) {
    int len = strlen(str);
    for (int i = len - 1; i >= 0; i--) {
        printf("%c", str[i]);
    }
}

// Recursive function to calculate factorial of a number
int factorial(int n) {
    if (n == 0) {
        return 1;
    } else {
        return n * factorial(n - 1);
    }
}

// Recursive function to print a pattern of stars
void printPattern(int n) {
    if (n == 0) {
        return;
    }
    for (int i = 0; i < n; i++) {
        printf("*");
    }
    printf("\n");
    printPattern(n - 1);
}

// Recursive function to solve Tower of Hanoi problem
void towerOfHanoi(int n, char from, char to, char aux) {
    if (n == 1) {
        printf("Move disk 1 from %c to %c\n", from, to);
        return;
    }
    towerOfHanoi(n - 1, from, aux, to);
    printf("Move disk %d from %c to %c\n", n, from, to);
    towerOfHanoi(n - 1, aux, to, from);
}

int main() {
    char str[100] = "Hello, World!";
    reverseString(str);
    printf("\n");

    int n = 5;
    printf("Factorial of %d is: %d\n", n, factorial(n));

    int m = 4;
    printPattern(m);

    int disks = 3;
    towerOfHanoi(disks, 'A', 'C', 'B');

    return 0;
}