//LLAMA2-13B DATASET v1.0 Category: Client Server Application ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8888

struct molecule {
    char name[20];
    int atomic_num;
};

int main(int argc, char *argv[]) {
    int sock, conn_sock;
    struct sockaddr_in server, client;
    struct molecule molecule;
    char buffer[256];

    // Create a socket
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("Socket creation failed");
        exit(EXIT_FAILURE);
    }

    // Set up the server address
    server.sin_family = AF_INET;
    server.sin_port = htons(PORT);
    inet_pton(AF_INET, "127.0.0.1", &server.sin_addr);

    // Connect to the server
    conn_sock = connect(sock, (struct sockaddr *)&server, sizeof(server));
    if (conn_sock < 0) {
        perror("Connection failed");
        exit(EXIT_FAILURE);
    }

    // Send a message to the server
    strcpy(buffer, "Hello, server!");
    send(sock, buffer, strlen(buffer), 0);

    // Receive a message from the server
    recv(sock, buffer, 256, 0);
    printf("Received message: %s\n", buffer);

    // Send a molecule to the server
    molecule.atomic_num = 6;
    strcpy(molecule.name, "Carbon");
    send(sock, &molecule, sizeof(molecule), 0);

    // Receive a molecule from the server
    recv(sock, &molecule, sizeof(molecule), 0);
    printf("Received molecule: %s (%d)\n", molecule.name, molecule.atomic_num);

    // Close the connection
    close(sock);

    return 0;
}