//GEMINI-pro DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: surrealist
// In an ethereal realm of swirling colors and whispering winds, where logic mingles with the fantastic, I present a CPU scheduling algorithm that defies the boundaries of the mundane.

#include <stdio.h>
#include <stdlib.h>

// A whimsical array to hold our processes, each with their own surreal name and burst time.
struct Process {
    char* name;
    int burstTime;
};

// Our canvas, a surrealist masterpiece of processes that weave through time.
struct Process processes[] = {
    { "Cosmic Dance", 20 },
    { "Chronoquake", 15 },
    { "Fractal Symphony", 12 },
    { "Ethereal Whisper", 10 },
    { "Infinite Dream", 25 },
    { "Paradoxical Waltz", 18 },
    { "Celestial Tapestry", 16 },
    { "Time Rift", 22 }
};

// The celestial artist, an FCFS algorithm that orchestrates the processes in a symphony of time.
void fcfs() {
    printf("In the cosmic theater of FCFS, time unfolds in a linear tapestry:\n");
    int totalTime = 0;
    for (int i = 0; i < 8; i++) {
        struct Process process = processes[i];
        totalTime += process.burstTime;
        printf("  %s: %d ms\n", process.name, process.burstTime);
    }
    printf("Total time: %d ms\n\n", totalTime);
}

// The surrealist maestro, an SJF algorithm that arranges the processes in a celestial queue based on their whimsical nature.
void sjf() {
    printf("In the enigmatic dance of SJF, time warps as processes twirl in ethereal queues:\n");
    struct Process sortedProcesses[8];
    for (int i = 0; i < 8; i++) {
        sortedProcesses[i] = processes[i];
    }

    // A cosmic bubble sort, levitating processes to their rightful temporal order.
    for (int i = 0; i < 8; i++) {
        for (int j = 0; j < 8 - i - 1; j++) {
            if (sortedProcesses[j].burstTime > sortedProcesses[j + 1].burstTime) {
                struct Process temp = sortedProcesses[j];
                sortedProcesses[j] = sortedProcesses[j + 1];
                sortedProcesses[j + 1] = temp;
            }
        }
    }

    int totalTime = 0;
    for (int i = 0; i < 8; i++) {
        struct Process process = sortedProcesses[i];
        totalTime += process.burstTime;
        printf("  %s: %d ms\n", process.name, process.burstTime);
    }
    printf("Total time: %d ms\n\n", totalTime);
}

// A chorus of cosmic melodies, an RR algorithm that paints the canvas of time with vibrant hues.
void rr() {
    printf("In the celestial chorus of RR, time whispers secrets in rhythmic intervals:\n");
    int timeQuantum = 5;
    int totalTime = 0;
    int remainingTime[8];

    for (int i = 0; i < 8; i++) {
        remainingTime[i] = processes[i].burstTime;
    }

    while (totalTime < 100) {
        for (int i = 0; i < 8; i++) {
            if (remainingTime[i] > 0) {
                if (remainingTime[i] > timeQuantum) {
                    printf("  %s: %d ms\n", processes[i].name, timeQuantum);
                    remainingTime[i] -= timeQuantum;
                    totalTime += timeQuantum;
                } else {
                    printf("  %s: %d ms\n", processes[i].name, remainingTime[i]);
                    totalTime += remainingTime[i];
                    remainingTime[i] = 0;
                }
            }
        }
    }
    printf("Total time: %d ms\n", totalTime);
}

// The surrealist masterpiece unveiled, a symphony of algorithms that paint the canvas of time in vibrant hues.
int main() {
    fcfs();
    sjf();
    rr();
    return 0;
}