//Gemma-7B DATASET v1.0 Category: Unit converter ; Style: configurable
#include <stdio.h>
#include <stdlib.h>

#define MAX_CONVERT_UNITS 10

typedef struct Unit {
  char name[20];
  int factor;
  double multiplier;
} Unit;

Unit units[MAX_CONVERT_UNITS] = {
  {"Gram", 1000, 1},
  {"Kilogram", 1000, 1000},
  {"Pound", 2000, 2.2046},
  {"Ounce", 3200, 0.03527},
  {"Liter", 1000, 1},
  {"Cubic Centimeter", 1000, 1000},
  {"Cubic Meter", 1000, 1000000},
  {"Fluid Ounce", 16, 1.6387},
  {"Pint", 16, 1.6387},
  {"Quart", 16, 1.6387}
};

void convert_units(double value, char from_unit, char to_unit) {
  int i;
  double factor = 1;

  for (i = 0; i < MAX_CONVERT_UNITS; i++) {
    if (strcmp(units[i].name, from_unit) == 0) {
      factor = units[i].factor;
    }
  }

  for (i = 0; i < MAX_CONVERT_UNITS; i++) {
    if (strcmp(units[i].name, to_unit) == 0) {
      value *= units[i].multiplier;
      value *= factor;
    }
  }

  printf("%f %s converted to %f %s is %f\n", value, from_unit, to_unit, units[i].name, value);
}

int main() {
  convert_units(10, "Gram", "Kilogram");
  convert_units(20, "Pound", "Ounce");
  convert_units(30, "Liter", "Cubic Centimeter");
  convert_units(40, "Fluid Ounce", "Quart");

  return 0;
}