//Falcon-180B DATASET v1.0 Category: Building a HTTP Client ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

/* Callback function to handle server response */
size_t WriteCallback(void* contents, size_t size, size_t nmemb, void* userp) {
    size_t realsize = size * nmemb;
    char* data = (char*)malloc(realsize + 1);
    memcpy(data, contents, realsize);
    data[realsize] = '\0';
    printf("%s", data);
    free(data);
    return realsize;
}

/* Main function to send HTTP request and receive response */
int main() {
    CURL* curl;
    CURLcode res;

    /* Initialize curl handle */
    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();

    /* Set URL to send request to */
    char* url = "http://example.com";
    curl_easy_setopt(curl, CURLOPT_URL, url);

    /* Set callback function to handle response */
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);

    /* Set options for HTTP request */
    curl_easy_setopt(curl, CURLOPT_CUSTOMREQUEST, "GET");
    curl_easy_setopt(curl, CURLOPT_HTTPGET, 1L);

    /* Send HTTP request and receive response */
    res = curl_easy_perform(curl);

    /* Check for errors in sending HTTP request */
    if(res!= CURLE_OK) {
        fprintf(stderr, "curl_easy_perform() failed: %s\n",
                curl_easy_strerror(res));
        exit(1);
    }

    /* Cleanup curl handle and global init */
    curl_easy_cleanup(curl);
    curl_global_cleanup();

    return 0;
}