//Falcon-180B DATASET v1.0 Category: Drone Remote Control ; Style: Alan Turing
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <string.h>

#define PI 3.14159265358979323846
#define GRAVITY 9.81
#define MAX_SPEED 10
#define MIN_SPEED 1
#define MAX_ALTITUDE 100
#define MIN_ALTITUDE 0
#define MAX_BATTERY_LIFE 20
#define MIN_BATTERY_LIFE 5
#define MAX_RANGE 1000
#define MIN_RANGE 50
#define MAX_WEIGHT 1000
#define MIN_WEIGHT 50
#define MAX_CAMERA_RESOLUTION 4K
#define MIN_CAMERA_RESOLUTION 720P

struct drone {
    char name[50];
    int speed;
    int altitude;
    int battery_life;
    int range;
    int weight;
    char camera_resolution[50];
};

void initialize_drone(struct drone* drone) {
    strcpy(drone->name, "DJI Phantom 4 Pro");
    drone->speed = rand() % (MAX_SPEED - MIN_SPEED + 1) + MIN_SPEED;
    drone->altitude = rand() % (MAX_ALTITUDE - MIN_ALTITUDE + 1) + MIN_ALTITUDE;
    drone->battery_life = rand() % (MAX_BATTERY_LIFE - MIN_BATTERY_LIFE + 1) + MIN_BATTERY_LIFE;
    drone->range = rand() % (MAX_RANGE - MIN_RANGE + 1) + MIN_RANGE;
    drone->weight = rand() % (MAX_WEIGHT - MIN_WEIGHT + 1) + MIN_WEIGHT;
    strcpy(drone->camera_resolution, "4K");
}

void print_drone_info(struct drone* drone) {
    printf("Name: %s\n", drone->name);
    printf("Speed: %d m/s\n", drone->speed);
    printf("Altitude: %d m\n", drone->altitude);
    printf("Battery life: %d minutes\n", drone->battery_life);
    printf("Range: %d m\n", drone->range);
    printf("Weight: %d g\n", drone->weight);
    printf("Camera resolution: %s\n", drone->camera_resolution);
}

int main() {
    srand(time(NULL));
    struct drone drone;
    initialize_drone(&drone);
    print_drone_info(&drone);
    return 0;
}