//LLAMA2-13B DATASET v1.0 Category: Database querying ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <assert.h>

#define MAX_LENGTH 1024
#define MAX_ROWS 10

typedef struct {
    char name[50];
    int age;
    char address[100];
} person;

person people[MAX_ROWS] = {
    {"Alice", 25, "123 Main St"},
    {"Bob", 30, "456 Elm St"},
    {"Charlie", 35, "789 Oak St"},
    {"David", 20, "901 Maple St"},
    {"Eve", 28, "111 Broadway"}
};

int main() {
    int i;
    char search_term[50];

    printf("Welcome to the curious database querying program!\n");

    // Query 1: Find all people named Alice
    printf("Find all people named Alice: ");
    for (i = 0; i < MAX_ROWS; i++) {
        if (strcmp(people[i].name, "Alice") == 0) {
            printf("%d: %s %d %s\n", i, people[i].name, people[i].age, people[i].address);
        }
    }

    // Query 2: Find all people over 30
    printf("Find all people over 30: ");
    for (i = 0; i < MAX_ROWS; i++) {
        if (people[i].age > 30) {
            printf("%d: %s %d %s\n", i, people[i].name, people[i].age, people[i].address);
        }
    }

    // Query 3: Find all people living on Elm St
    printf("Find all people living on Elm St: ");
    for (i = 0; i < MAX_ROWS; i++) {
        if (strcmp(people[i].address, "456 Elm St") == 0) {
            printf("%d: %s %d %s\n", i, people[i].name, people[i].age, people[i].address);
        }
    }

    // Query 4: Find all people born in March
    printf("Find all people born in March: ");
    for (i = 0; i < MAX_ROWS; i++) {
        if (people[i].age > 0 && people[i].age <= 31) {
            printf("%d: %s %d %s\n", i, people[i].name, people[i].age, people[i].address);
        }
    }

    // Query 5: Find all people with a birthday today
    printf("Find all people with a birthday today: ");
    for (i = 0; i < MAX_ROWS; i++) {
        if (people[i].age > 0 && people[i].age <= 365) {
            printf("%d: %s %d %s\n", i, people[i].name, people[i].age, people[i].address);
        }
    }

    return 0;
}