//Gemma-7B DATASET v1.0 Category: Haunted House Simulator ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_GORE_SOUNDS 5
#define MAX_BLOOD_SOUNDS 3

typedef struct Ghost
{
    char name[20];
    int appeased;
    int soundIndex;
    int bloodSoundIndex;
} Ghost;

Ghost ghosts[5] = {
    {"Sarah", 0, 0, 0},
    {"John", 0, 1, 1},
    {"Mary", 0, 2, 2},
    {"Jack", 0, 3, 3},
    {"Alice", 0, 4, 4}
};

void playGoreSound()
{
    int soundIndex = ghosts[0].soundIndex;
    if (soundIndex < MAX_GORE_SOUNDS)
    {
        soundIndex++;
        ghosts[0].soundIndex = soundIndex;
        playGoreSound();
    }
}

void playBloodSound()
{
    int soundIndex = ghosts[0].bloodSoundIndex;
    if (soundIndex < MAX_BLOOD_SOUNDS)
    {
        soundIndex++;
        ghosts[0].bloodSoundIndex = soundIndex;
        playBloodSound();
    }
}

void haunt()
{
    playGoreSound();
    playBloodSound();
    printf("The spirits of the house have awakened!\n");
    printf("Prepare for a terrifying encounter...\n");
    sleep(1);
    printf("BOO!\n");
    sleep(2);
    printf("The spirits have retreated.\n");
}

int main()
{
    haunt();
    return 0;
}