//Falcon-180B DATASET v1.0 Category: Appointment Scheduler ; Style: Claude Shannon
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_APPOINTMENTS 100
#define MAX_APPOINTMENT_LENGTH 50

struct appointment {
    char* description;
    time_t start_time;
    time_t end_time;
};

void add_appointment(struct appointment* appointments, int num_appointments, char* description, time_t start_time, time_t end_time) {
    if (num_appointments >= MAX_APPOINTMENTS) {
        printf("Sorry, cannot add more appointments.\n");
        return;
    }

    for (int i = 0; i < num_appointments; i++) {
        if (appointments[i].description == NULL) {
            appointments[i].description = malloc(MAX_APPOINTMENT_LENGTH);
            strncpy(appointments[i].description, description, MAX_APPOINTMENT_LENGTH - 1);
            appointments[i].description[MAX_APPOINTMENT_LENGTH - 1] = '\0';
            appointments[i].start_time = start_time;
            appointments[i].end_time = end_time;
            num_appointments++;
            return;
        }
    }

    printf("Sorry, cannot add appointment.\n");
}

void print_appointments(struct appointment* appointments, int num_appointments) {
    if (num_appointments == 0) {
        printf("No appointments.\n");
        return;
    }

    printf("Appointments:\n");
    for (int i = 0; i < num_appointments; i++) {
        printf("%s: %s - %s\n", appointments[i].description, ctime(&appointments[i].start_time), ctime(&appointments[i].end_time));
    }
}

void remove_appointment(struct appointment* appointments, int num_appointments, char* description) {
    for (int i = 0; i < num_appointments; i++) {
        if (strcmp(appointments[i].description, description) == 0) {
            free(appointments[i].description);
            appointments[i].description = NULL;
            appointments[i].start_time = 0;
            appointments[i].end_time = 0;
            num_appointments--;
            return;
        }
    }

    printf("Appointment not found.\n");
}

int main() {
    struct appointment appointments[MAX_APPOINTMENTS];
    int num_appointments = 0;

    add_appointment(appointments, num_appointments, "Meeting with boss", 1622780800, 1622784400);
    add_appointment(appointments, num_appointments, "Lunch with friends", 1622787200, 1622793600);

    print_appointments(appointments, num_appointments);

    remove_appointment(appointments, num_appointments, "Meeting with boss");

    print_appointments(appointments, num_appointments);

    return 0;
}