//Falcon-180B DATASET v1.0 Category: Interprocess communication ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#define TRUE 1
#define FALSE 0
#define MAX_SIZE 100

// Structure for the message queue
typedef struct {
    long type;
    char text[MAX_SIZE];
} message;

// Function to create a message queue
int create_queue(key_t key) {
    int qid;
    qid = msgget(key, IPC_CREAT | 0666);
    if (qid == -1) {
        perror("msgget");
        exit(1);
    }
    return qid;
}

// Function to send a message
void send_message(int qid, int msg_type, char* msg_text) {
    message msg;
    msg.type = msg_type;
    strcpy(msg.text, msg_text);
    msgsnd(qid, &msg, strlen(msg.text), 0);
}

// Function to receive a message
void receive_message(int qid, message* msg_buffer) {
    msgrcv(qid, msg_buffer, MAX_SIZE, 0, 0);
}

// Main function
int main(int argc, char* argv[]) {
    int qid;
    key_t key;
    key = ftok(".", 'a');
    qid = create_queue(key);

    // Fork a child process
    pid_t pid = fork();
    if (pid == 0) {
        // Child process
        send_message(qid, 1, "Hello from child process");
        exit(0);
    } else if (pid > 0) {
        // Parent process
        message msg_buffer;
        receive_message(qid, &msg_buffer);
        printf("Received message: %s\n", msg_buffer.text);
        send_message(qid, 2, "Hello from parent process");
        exit(0);
    } else {
        // Fork failed
        perror("fork");
        exit(1);
    }
    return 0;
}