//Falcon-180B DATASET v1.0 Category: System boot optimizer ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>

#define MAX_PROCESSES 10
#define MAX_PROCESS_NAME_LENGTH 20

typedef struct {
    char name[MAX_PROCESS_NAME_LENGTH];
    int priority;
    int state;
} process;

int num_processes = 0;
process processes[MAX_PROCESSES];

void add_process(char* name, int priority) {
    if (num_processes >= MAX_PROCESSES) {
        printf("Error: Cannot add more processes.\n");
        return;
    }

    strcpy(processes[num_processes].name, name);
    processes[num_processes].priority = priority;
    processes[num_processes].state = 0;

    num_processes++;
}

void remove_process(char* name) {
    int i;
    for (i = 0; i < num_processes; i++) {
        if (strcmp(processes[i].name, name) == 0) {
            processes[i].state = 1;
            num_processes--;
            break;
        }
    }
}

void print_processes() {
    int i;
    for (i = 0; i < num_processes; i++) {
        if (processes[i].state == 0) {
            printf("%s (%d)\n", processes[i].name, processes[i].priority);
        }
    }
}

int main() {
    add_process("Process A", 5);
    add_process("Process B", 3);
    add_process("Process C", 7);

    print_processes();

    remove_process("Process B");

    print_processes();

    return 0;
}