//GEMINI-pro DATASET v1.0 Category: Product Inventory System ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of products that can be stored
#define MAX_PRODUCTS 100

// Define the structure of a product
typedef struct {
    int id;
    char name[50];
    int quantity;
    float price;
} product;

// Declare the array of products
product products[MAX_PRODUCTS];

// Initialize the number of products to 0
int num_products = 0;

// Function to add a product to the inventory
void add_product(int id, char *name, int quantity, float price) {
    // Check if the array is full
    if (num_products >= MAX_PRODUCTS) {
        printf("Error: The product inventory is full.\n");
        return;
    }

    // Add the product to the array
    products[num_products].id = id;
    strcpy(products[num_products].name, name);
    products[num_products].quantity = quantity;
    products[num_products].price = price;

    // Increment the number of products
    num_products++;
}

// Function to remove a product from the inventory
void remove_product(int id) {
    // Find the index of the product in the array
    int index = -1;
    for (int i = 0; i < num_products; i++) {
        if (products[i].id == id) {
            index = i;
            break;
        }
    }

    // Check if the product was found
    if (index == -1) {
        printf("Error: The product was not found in the inventory.\n");
        return;
    }

    // Remove the product from the array
    for (int i = index; i < num_products - 1; i++) {
        products[i] = products[i + 1];
    }

    // Decrement the number of products
    num_products--;
}

// Function to update the quantity of a product in the inventory
void update_product(int id, int quantity) {
    // Find the index of the product in the array
    int index = -1;
    for (int i = 0; i < num_products; i++) {
        if (products[i].id == id) {
            index = i;
            break;
        }
    }

    // Check if the product was found
    if (index == -1) {
        printf("Error: The product was not found in the inventory.\n");
        return;
    }

    // Update the quantity of the product
    products[index].quantity = quantity;
}

// Function to print the inventory
void print_inventory() {
    printf("Product Inventory:\n");
    printf("===================\n");
    for (int i = 0; i < num_products; i++) {
        printf("ID: %d\n", products[i].id);
        printf("Name: %s\n", products[i].name);
        printf("Quantity: %d\n", products[i].quantity);
        printf("Price: $%.2f\n\n", products[i].price);
    }
}

// Main function
int main() {
    // Add some products to the inventory
    add_product(1, "Apple", 10, 1.00);
    add_product(2, "Orange", 15, 1.50);
    add_product(3, "Banana", 20, 2.00);
    add_product(4, "Grape", 25, 2.50);
    add_product(5, "Strawberry", 30, 3.00);

    // Print the inventory
    print_inventory();

    // Remove a product from the inventory
    remove_product(2);

    // Print the inventory again
    print_inventory();

    // Update the quantity of a product in the inventory
    update_product(1, 20);

    // Print the inventory again
    print_inventory();

    return 0;
}