//LLAMA2-13B DATASET v1.0 Category: Sorting ; Style: visionary
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_STRLEN 1024

// Define a structure to represent the elements to be sorted
typedef struct {
    char *name;
    int age;
} person_t;

// Define a function to compare two elements based on their age
int compare_age(const void *a, const void *b) {
    person_t *p1 = (person_t *)a;
    person_t *p2 = (person_t *)b;
    return p1->age - p2->age;
}

// Define a function to print the sorted list
void print_list(const void *arr, int num_elems) {
    int i;
    for (i = 0; i < num_elems; i++) {
        person_t *p = (person_t *)arr + i;
        printf("%s %d\n", p->name, p->age);
    }
}

int main() {
    // Define an array of structs to be sorted
    person_t arr[10] = {
        {"Alice", 25},
        {"Bob", 30},
        {"Charlie", 20},
        {"David", 35},
        {"Eve", 28},
        {"Frank", 38},
        {"Grace", 22},
        {"Helen", 32},
        {"Ivan", 31}
    };

    // Sort the array of structs using quicksort
    qsort(arr, 10, sizeof(person_t), compare_age);

    // Print the sorted list
    print_list(arr, 10);

    return 0;
}