//Falcon-180B DATASET v1.0 Category: Network Packet Monitoring ; Style: statistical
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pcap.h>
#include <arpa/inet.h>

#define SNAPLEN 65535
#define MAX_PACKETS 1000

struct packet_stats {
    int packets;
    int bytes;
};

void process_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct packet_stats *stats = (struct packet_stats *) args;
    stats->packets++;
    stats->bytes += header->caplen;
}

int main(int argc, char *argv[]) {
    char *dev = "eth0";
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    struct bpf_program fp;
    char filter_exp[] = "tcp or udp";
    int optimize = 1;
    int netmask = 0xffffff;
    int timeout = 1000;
    int flag = 1;

    if (argc > 1) {
        dev = argv[1];
    }

    handle = pcap_open_live(dev, SNAPLEN, flag, timeout, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Error opening device: %s\n", errbuf);
        exit(1);
    }

    if (pcap_compile(handle, &fp, filter_exp, optimize, netmask)!= 0) {
        fprintf(stderr, "Error compiling filter: %s\n", pcap_geterr(handle));
        exit(1);
    }

    if (pcap_setfilter(handle, &fp)!= 0) {
        fprintf(stderr, "Error setting filter: %s\n", pcap_geterr(handle));
        exit(1);
    }

    struct packet_stats stats = {0};
    pcap_loop(handle, -1, process_packet, (u_char *) &stats);

    pcap_freecode(&fp);
    pcap_close(handle);

    printf("Total packets: %d\n", stats.packets);
    printf("Total bytes: %d\n", stats.bytes);

    return 0;
}