//MISTRAL-7B DATASET v1.0 Category: Queue Implementation ; Style: recursive
#include <stdio.h>
#include <stdlib.h>
#define MAX_QUEUE_SIZE 10

typedef struct {
    int data[MAX_QUEUE_SIZE];
    int front;
    int rear;
} Queue;

void enqueue_helper(Queue *queue, int data) {
    if (queue->rear == MAX_QUEUE_SIZE - 1) {
        printf("Queue is full!\n");
        return;
    }

    if (queue->front == -1) {
        queue->front = 0;
    }

    queue->rear++;
    queue->data[queue->rear] = data;

    if (!is_queue_full(queue)) {
        enqueue_helper(queue, data);
    }
}

void enqueue(Queue *queue, int data) {
    enqueue_helper(queue, data);
}

int is_queue_full(Queue *queue) {
    return (queue->rear + 1) % MAX_QUEUE_SIZE == queue->front;
}

void dequeue(Queue *queue) {
    if (is_queue_empty(queue)) {
        printf("Queue is empty!\n");
        return;
    }

    int data = queue->data[queue->front];

    queue->front = (queue->front + 1) % MAX_QUEUE_SIZE;
}

int is_queue_empty(Queue *queue) {
    return queue->front == queue->rear;
}

int main() {
    Queue queue;
    queue.front = -1;
    queue.rear = -1;

    enqueue(&queue, 1);
    enqueue(&queue, 2);
    enqueue(&queue, 3);
    enqueue(&queue, 4);
    enqueue(&queue, 5);
    enqueue(&queue, 6);
    enqueue(&queue, 7);

    printf("Queue size: %d\n", queue.rear + 1);

    dequeue(&queue);
    dequeue(&queue);

    printf("Queue size: %d\n", queue.rear + 1);

    return 0;
}