//Falcon-180B DATASET v1.0 Category: Secure Password Generator ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define PASSWORD_LENGTH 12
#define CHARACTER_SET "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+{}[];:,.<>?/~"
#define MAX_ATTEMPTS 5

int generate_password(char *password);
int is_valid_password(char *password);

int main() {
    char password[PASSWORD_LENGTH + 1];
    int attempts = 0;

    srand(time(NULL));

    while (attempts < MAX_ATTEMPTS) {
        if (generate_password(password)) {
            printf("Generated password: %s\n", password);
            break;
        } else {
            printf("Invalid password. Please try again.\n");
            attempts++;
        }
    }

    return 0;
}

int generate_password(char *password) {
    int i;

    for (i = 0; i < PASSWORD_LENGTH; i++) {
        password[i] = CHARACTER_SET[rand() % strlen(CHARACTER_SET)];
    }

    password[PASSWORD_LENGTH] = '\0';

    return is_valid_password(password);
}

int is_valid_password(char *password) {
    int i;

    for (i = 0; i < PASSWORD_LENGTH; i++) {
        if (!isprint(password[i]) ||!isalnum(password[i])) {
            return 0;
        }
    }

    return 1;
}