//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: complete
#include <stdio.h>
#include <stdlib.h>

#define MAX_PROCESS 5
#define MAX_QUEUE_SIZE 10

typedef struct Process {
    int process_id;
    char name[20];
    int arrival_time;
    int burst_time;
    int waiting_time;
    int turnaround_time;
} Process;

void roundRobin(Process *processes, int num_processes) {
    int current_time = 0;
    int i = 0;
    int flag = 0;

    while (current_time < processes[0].turnaround_time) {
        if (processes[i].arrival_time <= current_time && processes[i].burst_time > 0) {
            processes[i].waiting_time--;
            processes[i].burst_time--;
            current_time++;

            if (processes[i].waiting_time == 0) {
                processes[i].turnaround_time = current_time;
                flag = 1;
            }
        }

        if (flag) {
            i = (i + 1) % num_processes;
            flag = 0;
        } else {
            current_time++;
        }
    }
}

int main() {
    Process processes[MAX_PROCESS] = {
        {1, "Process A", 0, 5, 0, 0},
        {2, "Process B", 2, 4, 0, 0},
        {3, "Process C", 3, 3, 0, 0},
        {4, "Process D", 4, 2, 0, 0},
        {5, "Process E", 5, 1, 0, 0}
    };

    roundRobin(processes, 5);

    printf("Process ID\tName\tArrival Time\tBurst Time\tWaiting Time\tTurnaround Time\n");
    for (int i = 0; i < MAX_PROCESS; i++) {
        printf("%d\t%s\t%d\t%d\t%d\t%d\n", processes[i].process_id, processes[i].name, processes[i].arrival_time, processes[i].burst_time, processes[i].waiting_time, processes[i].turnaround_time);
    }

    return 0;
}