//GPT-4o-mini DATASET v1.0 Category: Weather simulation ; Style: surrealist
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_CLOUDS 10
#define MAX_RAIN 20

typedef enum {SUNNY, CLOUDY, RAINY, STORMY} Weather;

typedef struct {
    Weather current_weather;
    int cloud_count;
    int rain_volume;
} Sky;

void generateWeather(Sky* sky) {
    sky->cloud_count = rand() % (MAX_CLOUDS + 1);
    sky->rain_volume = rand() % (MAX_RAIN + 1);
    
    int weather_choice = rand() % 4;
    
    switch(weather_choice) {
        case 0: 
            sky->current_weather = SUNNY; 
            break;
        case 1: 
            sky->current_weather = CLOUDY; 
            break;
        case 2: 
            sky->current_weather = RAINY; 
            break;
        case 3: 
            sky->current_weather = STORMY; 
            break;
    }
}

void describeWeather(Sky* sky) {
    char* weather_descriptions[] = {
        "The sun dances playfully above, sly shadows escaping its embrace.",
        "Clouds float lazily, ponderous thoughts draping the horizon.",
        "Rain falls as whispers of secrets long buried beneath the soil.",
        "Storms brew, a chaotic symphony pounding against the hearts of the earth."
    };

    printf("Current Weather: ");
    
    switch (sky->current_weather) {
        case SUNNY: 
            printf("%s\n", weather_descriptions[0]); 
            break;
        case CLOUDY: 
            printf("%s\n", weather_descriptions[1]); 
            break;
        case RAINY: 
            printf("%s\n", weather_descriptions[2]); 
            break;
        case STORMY: 
            printf("%s\n", weather_descriptions[3]); 
            break;
    }

    printf("Cloud count: %d\n", sky->cloud_count);
    printf("Rain volume: %d mL\n", sky->rain_volume);
}

void paintSky() {
    printf("\n~~*~~The sky, a canvas of dreams, shifting shades of imagination,~~*~~\n");
}

int main() {
    srand(time(0));
    
    Sky sky;
    
    for (int i = 0; i < 5; i++) {
        generateWeather(&sky);
        paintSky();
        describeWeather(&sky);
        printf("\n--------------------------------------------------\n");
        sleep(1);
    }

    printf("As the time wanders eternally into surreal vistas,\n");
    printf("The sun, clouds, rain, and storms merge into a timeless tide,\n");
    printf("Kissing the ground with dreams and embracing the whimsical.\n");

    return 0;
}