//Falcon-180B DATASET v1.0 Category: Packet Capturer with pcap library ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <stdbool.h>
#include <string.h>
#include <time.h>

#define MAX_PKT_SIZE 65535
#define SNAPLEN 1024
#define TRUE 1
#define FALSE 0

typedef struct {
    u_char *data;
    int len;
    time_t timestamp;
} Packet;

void process_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    Packet pkt;
    pkt.data = (u_char *) malloc(header->len);
    memcpy(pkt.data, packet, header->len);
    pkt.len = header->len;
    pkt.timestamp = header->ts.tv_sec * 1000000 + header->ts.tv_usec;
    printf("Received packet with length %d at %llu\n", pkt.len, pkt.timestamp);
    free(pkt.data);
}

int main() {
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    char filter_expr[50];
    struct bpf_program filter;
    int net = 0, mask = 0;
    int res;

    // Open capture device
    handle = pcap_open_live("eth0", SNAPLEN, TRUE, 0, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Error opening capture device: %s\n", errbuf);
        exit(1);
    }

    // Compile filter expression
    sprintf(filter_expr, "tcp");
    res = pcap_compile(handle, &filter, filter_expr, 0, net);
    if (res == -1) {
        fprintf(stderr, "Error compiling filter expression: %s\n", pcap_geterr(handle));
        exit(1);
    }

    // Set filter
    res = pcap_setfilter(handle, &filter);
    if (res == -1) {
        fprintf(stderr, "Error setting filter: %s\n", pcap_geterr(handle));
        exit(1);
    }

    // Start capturing packets
    res = pcap_loop(handle, -1, process_packet, NULL);
    if (res == -1) {
        fprintf(stderr, "Error capturing packets: %s\n", pcap_geterr(handle));
        exit(1);
    }

    // Close capture device
    pcap_freecode(&filter);
    pcap_close(handle);

    return 0;
}