//GEMINI-pro DATASET v1.0 Category: Dice Roller ; Style: mind-bending
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the number of sides on the dice.
#define NUM_SIDES 6

// Define the number of dice to roll.
#define NUM_DICE 2

// Define the maximum possible value for a roll.
#define MAX_ROLL (NUM_SIDES * NUM_DICE)

// Define the minimum possible value for a roll.
#define MIN_ROLL (NUM_DICE)

// Define the range of possible values for a roll.
#define RANGE (MAX_ROLL - MIN_ROLL + 1)

// Declare the dice rolling function.
int roll_dice(void);

// Declare the main function.
int main(void) {
    // Set the random seed.
    srand(time(NULL));

    // Roll the dice.
    int roll = roll_dice();

    // Print the result.
    printf("You rolled a %d.\n", roll);

    return 0;
}

// Define the dice rolling function.
int roll_dice(void) {
    // Declare the array of dice rolls.
    int rolls[NUM_DICE];

    // Roll each die.
    for (int i = 0; i < NUM_DICE; i++) {
        rolls[i] = rand() % NUM_SIDES + 1;
    }

    // Calculate the total roll.
    int total = 0;
    for (int i = 0; i < NUM_DICE; i++) {
        total += rolls[i];
    }

    // Return the total roll.
    return total;
}