//GPT-4o-mini DATASET v1.0 Category: Wireless Network Scanner ; Style: funny
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define a structure for wireless networks
typedef struct {
    char ssid[50];
    int signal_strength; // In dBm
    char encryption_type[20];
} WirelessNetwork;

// Define some sample networks (more fictitious than wifi)
WirelessNetwork networks[] = {
    {"Free Wi-Fi", -70, "None"},
    {"Coffee Shop WiFi", -60, "WPA2"},
    {"UnicornLand", -80, "WEP"},
    {"NSA_SpyNet", -40, "WPA3"},
    {"404-Network-Not-Found", -90, "Somewhere Over The Rainbow"},
    {"TheDarkSideOfTheNet", -50, "DefinitelyNotWPA"},
    {"PrettyFlyForAWiFi", -85, "WPA"},
    {"InThisHouseWeUseLinux", -20, "Open"},
};

#define TOTAL_NETWORKS (sizeof(networks) / sizeof(networks[0]))

// Function to simulate scanning wireless networks
void scan_networks() {
    printf("Scanning for wireless networks... 🕵️‍♂️\n");
    printf("========================================\n");
    
    // Loop through network list
    for (int i = 0; i < TOTAL_NETWORKS; i++) {
        printf("SSID: %-30s Signal Strength: %3d dBm Encryption: %-20s\n",
               networks[i].ssid, networks[i].signal_strength, networks[i].encryption_type);
    }

    printf("========================================\n");
    printf("Scanning complete! 🚀\n");
}

// Function to simulate a decision based on scanned networks
void choose_network() {
    printf("Which network should we tap into? 🤔\n");
    
    // Making a bizarre decision-making process
    int choice = rand() % TOTAL_NETWORKS;
    
    printf("Let's select: '%s' with signal %d dBm (Hope it doesn't require a password!) 😅\n",
           networks[choice].ssid, networks[choice].signal_strength);
    
    if (strcmp(networks[choice].encryption_type, "None") == 0) {
        printf("Yay! This one is wide open! 🥳\n");
    } else {   
        printf("Oops! Looks like we need a password. Time to explore! 🔍\n");
    }
    
    printf("But life is short, let's just get some coffee instead! ☕\n");
}

int main() {
    // Seed the random number generator
    srand((unsigned int)time(NULL));
    
    // Begin the wireless network scanning adventure!
    scan_networks();
    
    // Choose a network in a completely nonsensical way
    choose_network();
    
    // An epic end to the saga
    printf("End of wireless adventure! Remember, sharing is caring... unless you share your Wi-Fi password! 🤫\n");
    
    return 0;
}