//Falcon-180B DATASET v1.0 Category: Personal Finance Planner ; Style: realistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100

typedef struct {
    char name[50];
    double amount;
    char category[50];
    int is_expense;
} item;

void add_item(item* items, int count, char* name, double amount, char* category, int is_expense) {
    if (count >= MAX_ITEMS) {
        printf("Error: Maximum number of items reached.\n");
        return;
    }

    strcpy(items[count].name, name);
    items[count].amount = amount;
    strcpy(items[count].category, category);
    items[count].is_expense = is_expense;

    count++;
}

void print_items(item* items, int count) {
    printf("Items:\n");

    for (int i = 0; i < count; i++) {
        printf("%s - $%.2f - %s - %s\n", items[i].name, items[i].amount, items[i].category, items[i].is_expense? "Expense" : "Income");
    }
}

void print_summary(item* items, int count) {
    double total_expenses = 0;
    double total_income = 0;

    printf("\nSummary:\n");
    printf("Total Expenses: $%.2f\n", total_expenses);
    printf("Total Income: $%.2f\n", total_income);
}

int main() {
    item items[MAX_ITEMS];
    int count = 0;

    add_item(items, count, "Rent", 1000, "Housing", 1);
    add_item(items, count, "Groceries", 200, "Food", 1);
    add_item(items, count, "Salary", 3000, "Income", 0);
    add_item(items, count, "Clothing", 100, "Shopping", 1);
    add_item(items, count, "Utilities", 150, "Housing", 1);

    print_items(items, count);
    print_summary(items, count);

    return 0;
}