//Falcon-180B DATASET v1.0 Category: Geometric algorithms ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

struct Point {
    double x;
    double y;
};

struct Line {
    struct Point p1;
    struct Point p2;
};

double distance(struct Point p1, struct Point p2) {
    double dx = p2.x - p1.x;
    double dy = p2.y - p1.y;
    return sqrt(dx*dx + dy*dy);
}

double angle(struct Point p1, struct Point p2, struct Point p3) {
    double ab = distance(p1, p2);
    double bc = distance(p2, p3);
    double ac = distance(p1, p3);
    double cosine = (ab*ab + bc*bc - ac*ac) / (2*ab*bc);
    return acos(cosine);
}

double area(struct Point p1, struct Point p2, struct Point p3) {
    double ab = distance(p1, p2);
    double bc = distance(p2, p3);
    double ac = distance(p3, p1);
    double s = (ab + bc + ac) / 2;
    return sqrt(s*(s-ab)*(s-bc)*(s-ac));
}

int main() {
    struct Point p1 = {0, 0};
    struct Point p2 = {1, 0};
    struct Point p3 = {0, 1};
    struct Point p4 = {1, 1};
    struct Line l1 = {p1, p2};
    struct Line l2 = {p3, p4};
    double d = distance(p1, p3);
    double a = angle(p1, p2, p3);
    double A = area(p1, p2, p3);
    printf("Distance: %lf\n", d);
    printf("Angle: %lf\n", a);
    printf("Area: %lf\n", A);
    return 0;
}