//Code Llama-13B DATASET v1.0 Category: Fitness Tracker ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>

// Define the structure for a fitness tracker
typedef struct {
  int weight;
  int height;
  int age;
  int activity_level;
  int goal;
} FitnessTracker;

// Define the methods for the fitness tracker
void init_fitness_tracker(FitnessTracker* tracker) {
  tracker->weight = 0;
  tracker->height = 0;
  tracker->age = 0;
  tracker->activity_level = 0;
  tracker->goal = 0;
}

void set_weight(FitnessTracker* tracker, int weight) {
  tracker->weight = weight;
}

void set_height(FitnessTracker* tracker, int height) {
  tracker->height = height;
}

void set_age(FitnessTracker* tracker, int age) {
  tracker->age = age;
}

void set_activity_level(FitnessTracker* tracker, int activity_level) {
  tracker->activity_level = activity_level;
}

void set_goal(FitnessTracker* tracker, int goal) {
  tracker->goal = goal;
}

int calculate_bmi(FitnessTracker* tracker) {
  return (tracker->weight / (tracker->height * tracker->height)) * 703;
}

void print_fitness_tracker(FitnessTracker* tracker) {
  printf("Fitness Tracker\n");
  printf("Weight: %d\n", tracker->weight);
  printf("Height: %d\n", tracker->height);
  printf("Age: %d\n", tracker->age);
  printf("Activity Level: %d\n", tracker->activity_level);
  printf("Goal: %d\n", tracker->goal);
}

int main() {
  // Initialize the fitness tracker
  FitnessTracker tracker;
  init_fitness_tracker(&tracker);

  // Set the weight, height, age, activity level, and goal
  set_weight(&tracker, 150);
  set_height(&tracker, 70);
  set_age(&tracker, 25);
  set_activity_level(&tracker, 3);
  set_goal(&tracker, 200);

  // Calculate the BMI
  int bmi = calculate_bmi(&tracker);
  printf("BMI: %d\n", bmi);

  // Print the fitness tracker
  print_fitness_tracker(&tracker);

  return 0;
}