//Gemma-7B DATASET v1.0 Category: Error handling ; Style: immersive
#include <stdio.h>
#include <stdlib.h>

#define MAX_SIZE 10

typedef struct Node {
    int data;
    struct Node* next;
} Node;

Node* createNode(int data) {
    Node* newNode = malloc(sizeof(Node));
    newNode->data = data;
    newNode->next = NULL;

    return newNode;
}

int insertAtTail(Node* head, int data) {
    if (head == NULL) {
        return -1;
    }

    Node* newNode = createNode(data);
    if (newNode == NULL) {
        return -2;
    }

    if (head->next == NULL) {
        head->next = newNode;
    } else {
        Node* temp = head;
        while (temp->next) {
            temp = temp->next;
        }
        temp->next = newNode;
    }

    return 0;
}

int main() {
    Node* head = NULL;

    insertAtTail(head, 10);
    insertAtTail(head, 20);
    insertAtTail(head, 30);
    insertAtTail(head, 40);

    if (head) {
        printf("Data of the first node: %d\n", head->data);
        printf("Data of the last node: %d\n", head->next->next->next->data);
    } else {
        printf("List is empty\n");
    }

    return 0;
}