//Code Llama-13B DATASET v1.0 Category: TCP/IP Programming ; Style: happy
// Happy TCP/IP Programming Example

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>

int main() {
    int sockfd, new_fd;
    struct sockaddr_in server_addr, client_addr;
    socklen_t client_len = sizeof(client_addr);
    char buffer[256] = {0};
    char *hello = "Hello, client!";

    // Create a socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        perror("socket");
        exit(1);
    }

    // Set server address
    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    server_addr.sin_port = htons(8000);

    // Bind the socket
    if (bind(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("bind");
        exit(1);
    }

    // Listen on the socket
    if (listen(sockfd, 3) < 0) {
        perror("listen");
        exit(1);
    }

    // Accept incoming connections
    new_fd = accept(sockfd, (struct sockaddr *)&client_addr, &client_len);
    if (new_fd < 0) {
        perror("accept");
        exit(1);
    }

    // Receive data from the client
    recv(new_fd, buffer, 255, 0);

    // Send data to the client
    send(new_fd, hello, strlen(hello), 0);

    // Close the socket
    close(new_fd);
    close(sockfd);

    return 0;
}