//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: complete
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the weather types
enum weather_type {
    SUNNY,
    RAINY,
    SNOWY,
    WINDY
};

// Define the weather probabilities
const float weather_probabilities[] = {
    0.5, // SUNNY
    0.25, // RAINY
    0.15, // SNOWY
    0.1 // WINDY
};

// Get a random weather type
enum weather_type get_random_weather() {
    float random_value = (float) rand() / RAND_MAX;
    float cumulative_probability = 0.0;
    for (int i = 0; i < 4; i++) {
        cumulative_probability += weather_probabilities[i];
        if (random_value <= cumulative_probability) {
            return i;
        }
    }
    return -1; // Shouldn't reach here
}

// Simulate a day of weather
void simulate_weather() {
    enum weather_type weather = get_random_weather();
    switch (weather) {
        case SUNNY:
            printf("The weather is sunny today.\n");
            break;
        case RAINY:
            printf("The weather is rainy today.\n");
            break;
        case SNOWY:
            printf("The weather is snowy today.\n");
            break;
        case WINDY:
            printf("The weather is windy today.\n");
            break;
    }
}

// Main function
int main() {
    // Initialize the random number generator
    srand(time(NULL));

    // Simulate 10 days of weather
    for (int i = 0; i < 10; i++) {
        simulate_weather();
    }

    return 0;
}