//Code Llama-13B DATASET v1.0 Category: Procedurally Generated Maze ; Style: invasive
/*
 * A procedurally generated maze example program in an invasive style
 * Generates a maze using a randomized algorithm
 *
 * Author: [Your Name]
 * Date: [Current Date]
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define WIDTH 10
#define HEIGHT 10
#define NUM_ROOMS 5

// Struct to represent a maze room
typedef struct {
    int x;
    int y;
    int width;
    int height;
    int door_x;
    int door_y;
} room_t;

// Generates a random number between min and max (inclusive)
int rand_range(int min, int max) {
    return min + rand() % (max - min + 1);
}

// Generates a random door position for a room
void generate_door(room_t *room) {
    room->door_x = rand_range(room->x, room->x + room->width - 1);
    room->door_y = rand_range(room->y, room->y + room->height - 1);
}

// Generates a random room size and position
void generate_room(room_t *room) {
    room->x = rand_range(0, WIDTH - 1);
    room->y = rand_range(0, HEIGHT - 1);
    room->width = rand_range(2, 5);
    room->height = rand_range(2, 5);
    generate_door(room);
}

// Prints a maze room
void print_room(room_t *room) {
    int x, y;
    for (x = room->x; x < room->x + room->width; x++) {
        for (y = room->y; y < room->y + room->height; y++) {
            if (x == room->door_x && y == room->door_y) {
                printf("D");
            } else {
                printf(" ");
            }
        }
        printf("\n");
    }
}

// Prints a maze using a randomized algorithm
void print_maze(room_t *rooms, int num_rooms) {
    int i, j;
    for (i = 0; i < num_rooms; i++) {
        print_room(&rooms[i]);
    }
}

int main() {
    // Generate rooms
    room_t rooms[NUM_ROOMS];
    int i;
    for (i = 0; i < NUM_ROOMS; i++) {
        generate_room(&rooms[i]);
    }

    // Print maze
    print_maze(rooms, NUM_ROOMS);

    return 0;
}