//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the weather types
enum weather_type {
    SUNNY,
    CLOUDY,
    RAINY,
    STORMY
};

// Define the weather data structure
struct weather {
    enum weather_type type;
    int temperature;
    int humidity;
    int wind_speed;
};

// Generate a random weather forecast
struct weather generate_weather() {
    struct weather weather;

    // Set the weather type
    weather.type = rand() % 4;

    // Set the temperature
    weather.temperature = rand() % 30 + 10;

    // Set the humidity
    weather.humidity = rand() % 100;

    // Set the wind speed
    weather.wind_speed = rand() % 100;

    return weather;
}

// Print the weather forecast
void print_weather(struct weather weather) {
    switch (weather.type) {
    case SUNNY:
        printf("The weather is sunny.\n");
        break;
    case CLOUDY:
        printf("The weather is cloudy.\n");
        break;
    case RAINY:
        printf("The weather is rainy.\n");
        break;
    case STORMY:
        printf("The weather is stormy.\n");
        break;
    }

    printf("The temperature is %d degrees Fahrenheit.\n", weather.temperature);
    printf("The humidity is %d percent.\n", weather.humidity);
    printf("The wind speed is %d miles per hour.\n", weather.wind_speed);
}

// Main function
int main() {
    // Seed the random number generator
    srand(time(NULL));

    // Generate a weather forecast
    struct weather weather = generate_weather();

    // Print the weather forecast
    print_weather(weather);

    return 0;
}