//Falcon2-11B DATASET v1.0 Category: Music Library Management System ; Style: puzzling
#include <stdio.h>

// Struct for storing information about each song
struct Song {
    char title[50];
    int duration;
};

// Function to add a new song to the library
void add_song(struct Song* library, char* title, int duration) {
    library->title[0] = '\0'; // Null-terminate string
    strcpy(library->title, title);
    library->duration = duration;
}

// Function to remove a song from the library
void remove_song(struct Song* library, char* title) {
    int i;
    for (i = 0; i < 50; i++) {
        if (library->title[i] == '\0') {
            break; // Found null terminator
        }
        if (strcmp(library->title + i, title) == 0) {
            library->title[i] = '\0'; // Null-terminate string
            break;
        }
    }
}

// Function to display all songs in the library
void display_songs(struct Song* library, int count) {
    int i;
    for (i = 0; i < count; i++) {
        printf("Title: %s\nDuration: %d seconds\n", library[i].title, library[i].duration);
    }
}

int main() {
    // Create an empty library
    struct Song library[100];
    int count = 0;

    // Add some songs to the library
    add_song(&library[count++], "Song 1", 240);
    add_song(&library[count++], "Song 2", 180);
    add_song(&library[count++], "Song 3", 120);

    // Display all songs in the library
    display_songs(&library[0], count);

    // Remove a song from the library
    remove_song(&library[0], "Song 2");

    // Display all songs in the library again
    display_songs(&library[0], count);

    return 0;
}