//Falcon-180B DATASET v1.0 Category: Traffic Light Controller ; Style: irregular
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <signal.h>

#define RED_LIGHT_DURATION 10
#define GREEN_LIGHT_DURATION 15
#define YELLOW_LIGHT_DURATION 5
#define TOTAL_DURATION (RED_LIGHT_DURATION + GREEN_LIGHT_DURATION + YELLOW_LIGHT_DURATION)

void traffic_light_controller(int duration) {
    int red_light_duration = duration / RED_LIGHT_DURATION;
    int green_light_duration = duration / GREEN_LIGHT_DURATION;
    int yellow_light_duration = duration / YELLOW_LIGHT_DURATION;

    printf("Traffic light controller started with duration %d\n", duration);
    printf("Red light duration: %d\n", red_light_duration);
    printf("Green light duration: %d\n", green_light_duration);
    printf("Yellow light duration: %d\n", yellow_light_duration);

    for (int i = 0; i < red_light_duration; i++) {
        printf("Red light on\n");
        fflush(stdout);
        sleep(1);
    }

    for (int i = 0; i < green_light_duration; i++) {
        printf("Green light on\n");
        fflush(stdout);
        sleep(1);
    }

    for (int i = 0; i < yellow_light_duration; i++) {
        printf("Yellow light on\n");
        fflush(stdout);
        sleep(1);
    }
}

void signal_handler(int signal) {
    if (signal == SIGINT) {
        printf("Traffic light controller stopped\n");
    }
}

int main() {
    int duration = TOTAL_DURATION;

    signal(SIGINT, signal_handler);

    traffic_light_controller(duration);

    return 0;
}