//GEMINI-pro DATASET v1.0 Category: Phone Book ; Style: accurate
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of contacts
#define MAX_CONTACTS 100

// Define the structure of a contact
typedef struct contact {
    char name[50];
    char phone_number[20];
    char email[50];
} contact;

// Define the phone book as an array of contacts
contact phone_book[MAX_CONTACTS];

// Define the current number of contacts in the phone book
int num_contacts = 0;

// Function to add a new contact to the phone book
void add_contact(char *name, char *phone_number, char *email) {
    // Check if the phone book is full
    if (num_contacts == MAX_CONTACTS) {
        printf("Error: Phone book is full.\n");
        return;
    }

    // Copy the contact information into the phone book
    strcpy(phone_book[num_contacts].name, name);
    strcpy(phone_book[num_contacts].phone_number, phone_number);
    strcpy(phone_book[num_contacts].email, email);

    // Increment the number of contacts
    num_contacts++;
}

// Function to search for a contact in the phone book
contact *search_contact(char *name) {
    // Iterate over the contacts in the phone book
    for (int i = 0; i < num_contacts; i++) {
        // Check if the contact's name matches the search term
        if (strcmp(phone_book[i].name, name) == 0) {
            // Return a pointer to the contact
            return &phone_book[i];
        }
    }

    // Return NULL if the contact was not found
    return NULL;
}

// Function to print the phone book
void print_phone_book() {
    // Iterate over the contacts in the phone book
    for (int i = 0; i < num_contacts; i++) {
        // Print the contact's information
        printf("%s (%s) %s\n", phone_book[i].name, phone_book[i].phone_number, phone_book[i].email);
    }
}

// Main function
int main() {
    // Add some contacts to the phone book
    add_contact("John Doe", "555-1212", "john.doe@example.com");
    add_contact("Jane Doe", "555-1213", "jane.doe@example.com");
    add_contact("John Smith", "555-1214", "john.smith@example.com");

    // Search for a contact in the phone book
    contact *contact = search_contact("John Doe");

    // Print the contact's information
    if (contact != NULL) {
        printf("Found contact:\n");
        printf("%s (%s) %s\n", contact->name, contact->phone_number, contact->email);
    } else {
        printf("Contact not found.\n");
    }

    // Print the phone book
    printf("\nPhone book:\n");
    print_phone_book();

    return 0;
}