//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: careful
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the weather conditions
#define SUNNY 0
#define CLOUDY 1
#define RAINING 2
#define SNOWING 3

// Define the temperature range
#define MIN_TEMP -10
#define MAX_TEMP 40

// Define the wind speed range
#define MIN_WIND_SPEED 0
#define MAX_WIND_SPEED 100

// Define the precipitation range
#define MIN_PRECIPITATION 0
#define MAX_PRECIPITATION 100

// Define the time step
#define TIME_STEP 1

// Create a function to generate a random weather condition
int generate_weather_condition() {
  // Get a random number between 0 and 3
  int random_number = rand() % 4;

  // Return the weather condition
  return random_number;
}

// Create a function to generate a random temperature
int generate_temperature() {
  // Get a random number between MIN_TEMP and MAX_TEMP
  int random_number = rand() % (MAX_TEMP - MIN_TEMP + 1) + MIN_TEMP;

  // Return the temperature
  return random_number;
}

// Create a function to generate a random wind speed
int generate_wind_speed() {
  // Get a random number between MIN_WIND_SPEED and MAX_WIND_SPEED
  int random_number = rand() % (MAX_WIND_SPEED - MIN_WIND_SPEED + 1) + MIN_WIND_SPEED;

  // Return the wind speed
  return random_number;
}

// Create a function to generate a random precipitation amount
int generate_precipitation() {
  // Get a random number between MIN_PRECIPITATION and MAX_PRECIPITATION
  int random_number = rand() % (MAX_PRECIPITATION - MIN_PRECIPITATION + 1) + MIN_PRECIPITATION;

  // Return the precipitation amount
  return random_number;
}

// Create a function to print the weather conditions
void print_weather_conditions(int weather_condition, int temperature, int wind_speed, int precipitation) {
  // Print the weather condition
  switch (weather_condition) {
    case SUNNY:
      printf("The weather is sunny.\n");
      break;
    case CLOUDY:
      printf("The weather is cloudy.\n");
      break;
    case RAINING:
      printf("The weather is raining.\n");
      break;
    case SNOWING:
      printf("The weather is snowing.\n");
      break;
  }

  // Print the temperature
  printf("The temperature is %d degrees Fahrenheit.\n", temperature);

  // Print the wind speed
  printf("The wind speed is %d miles per hour.\n", wind_speed);

  // Print the precipitation amount
  printf("The precipitation amount is %d inches.\n", precipitation);
}

// Create a function to simulate the weather
void simulate_weather() {
  // Get the current time
  time_t current_time = time(NULL);

  // Initialize the weather conditions
  int weather_condition = generate_weather_condition();
  int temperature = generate_temperature();
  int wind_speed = generate_wind_speed();
  int precipitation = generate_precipitation();

  // Print the initial weather conditions
  printf("The initial weather conditions are:\n");
  print_weather_conditions(weather_condition, temperature, wind_speed, precipitation);

  // Simulate the weather for 10 time steps
  for (int i = 0; i < 10; i++) {
    // Update the weather conditions
    weather_condition = generate_weather_condition();
    temperature = generate_temperature();
    wind_speed = generate_wind_speed();
    precipitation = generate_precipitation();

    // Print the updated weather conditions
    printf("\nThe weather conditions at time %d are:\n", i + 1);
    print_weather_conditions(weather_condition, temperature, wind_speed, precipitation);

    // Sleep for the time step
    sleep(TIME_STEP);
  }
}

// Main function
int main() {
  // Initialize the random seed
  srand(time(NULL));

  // Simulate the weather
  simulate_weather();

  return 0;
}