//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Define a point in 2D space
typedef struct {
    double x;
    double y;
} point;

// Define a line segment in 2D space
typedef struct {
    point p1;
    point p2;
} line_segment;

// Define a circle in 2D space
typedef struct {
    point center;
    double radius;
} circle;

// Function to check if a point is inside a circle
int point_in_circle(point p, circle c) {
    double dx = p.x - c.center.x;
    double dy = p.y - c.center.y;
    return dx * dx + dy * dy <= c.radius * c.radius;
}

// Function to check if a line segment intersects a circle
int line_segment_intersects_circle(line_segment s, circle c) {
    // Check if the endpoints of the line segment are inside the circle
    int p1_in_circle = point_in_circle(s.p1, c);
    int p2_in_circle = point_in_circle(s.p2, c);

    // If both endpoints are inside the circle, the line segment is inside the circle
    if (p1_in_circle && p2_in_circle) {
        return 1;
    }

    // If one endpoint is inside the circle and the other is outside the circle, the line segment intersects the circle
    if (p1_in_circle || p2_in_circle) {
        return 1;
    }

    // If both endpoints are outside the circle, the line segment does not intersect the circle
    return 0;
}

// Function to find the intersection point of a line segment and a circle
point line_segment_circle_intersection(line_segment s, circle c) {
    // Check if the line segment intersects the circle
    if (!line_segment_intersects_circle(s, c)) {
        fprintf(stderr, "Line segment and circle do not intersect\n");
        exit(1);
    }

    // Find the midpoint of the line segment
    point midpoint;
    midpoint.x = (s.p1.x + s.p2.x) / 2;
    midpoint.y = (s.p1.y + s.p2.y) / 2;

    // Find the vector from the midpoint of the line segment to the center of the circle
    double dx = c.center.x - midpoint.x;
    double dy = c.center.y - midpoint.y;

    // Find the projection of the vector onto the line segment
    double projection = (dx * (s.p2.x - s.p1.x) + dy * (s.p2.y - s.p1.y)) / ((s.p2.x - s.p1.x) * (s.p2.x - s.p1.x) + (s.p2.y - s.p1.y) * (s.p2.y - s.p1.y));

    // Find the intersection point
    point intersection;
    intersection.x = midpoint.x + projection * (s.p2.x - s.p1.x);
    intersection.y = midpoint.y + projection * (s.p2.y - s.p1.y);

    return intersection;
}

// Main function
int main() {
    // Define a circle
    circle c;
    c.center.x = 0;
    c.center.y = 0;
    c.radius = 1;

    // Define a line segment
    line_segment s;
    s.p1.x = -1;
    s.p1.y = 0;
    s.p2.x = 1;
    s.p2.y = 0;

    // Check if the line segment intersects the circle
    int intersects = line_segment_intersects_circle(s, c);

    // If the line segment intersects the circle, find the intersection point
    point intersection;
    if (intersects) {
        intersection = line_segment_circle_intersection(s, c);
        printf("Intersection point: (%f, %f)\n", intersection.x, intersection.y);
    } else {
        printf("Line segment and circle do not intersect\n");
    }

    return 0;
}