//MISTRAL-7B DATASET v1.0 Category: Queue Implementation ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_QUEUE_SIZE 5

typedef struct CircularQueue {
    int front;
    int rear;
    int queue[MAX_QUEUE_SIZE];
} CircularQueue;

void initQueue(CircularQueue *queue) {
    queue->front = 0;
    queue->rear = 0;
}

int isQueueFull(CircularQueue *queue) {
    return ((queue->rear + 1) % MAX_QUEUE_SIZE == queue->front);
}

int enqueue(CircularQueue *queue, int data) {
    if (isQueueFull(queue)) {
        printf("Error: Queue is full.\n");
        return 0;
    }

    queue->queue[queue->rear] = data;
    queue->rear = (queue->rear + 1) % MAX_QUEUE_SIZE;

    return 1;
}

int dequeue(CircularQueue *queue) {
    if (isEmpty(queue)) {
        printf("Error: Queue is empty.\n");
        return 0;
    }

    int data = queue->queue[queue->front];
    queue->front = (queue->front + 1) % MAX_QUEUE_SIZE;

    return data;
}

int isEmpty(CircularQueue *queue) {
    return (queue->front == queue->rear);
}

int main() {
    CircularQueue queue;
    initQueue(&queue);

    char names[6][20] = {"Watson", "Moriarty", "Doyle", "Lestrade", "Hudson", "Hopkins"};
    int i;

    printf("\nA Scandal in Bohemia: A Circular Queue Enigma\n");

    for (i = 0; i < 5; i++) {
        if (enqueue(&queue, i)) {
            printf("Enqueued %s (%d): %s\n", names[i], i, names[i]);
        } else {
            printf("Error: Failed to enqueue %s (%d)\n", names[i], i);
            break;
        }
    }

    printf("\nFront: %d, Rear: %d\n", queue.front, queue.rear);
    printf("Queue: ");

    for (i = 0; i < MAX_QUEUE_SIZE; i++) {
        if (i == queue.front) continue;
        printf("%d ", queue.queue[i]);
    }
    printf("\b\n");

    printf("\nDequeued: ");

    for (i = 0; i < 5; i++) {
        int data = dequeue(&queue);
        printf("%s (%d) ", names[data], data);
    }
    printf("\n");

    return 0;
}