//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: synchronous
#include <stdio.h>
#include <string.h>

// Define the maximum number of items that can be ordered
#define MAX_ITEMS 10

// Define the structure of an item
typedef struct Item {
    char name[20];
    int quantity;
    float price;
} Item;

// Create an array of items
Item items[MAX_ITEMS];

// Function to add an item to the array
void add_item(char* name, int quantity, float price) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            strcpy(items[i].name, name);
            items[i].quantity = quantity;
            items[i].price = price;
            return;
        }
    }

    // If the array is full, print an error message
    printf("Error: The array is full.\n");
}

// Function to calculate the total cost of an order
float calculate_total(int num_items) {
    float total_cost = 0.0f;

    for (int i = 0; i < num_items; i++) {
        total_cost += items[i].quantity * items[i].price;
    }

    return total_cost;
}

// Function to print the order
void print_order(int num_items) {
    printf("Order:\n");

    for (int i = 0; i < num_items; i++) {
        printf("%s: %d @ %.2f\n", items[i].name, items[i].quantity, items[i].price);
    }

    printf("Total cost: %.2f\n", calculate_total(num_items));
}

int main() {
    // Add some items to the array
    add_item("Coffee", 2, 3.0f);
    add_item("Tea", 1, 2.0f);
    add_item("Juice", 3, 4.0f);

    // Print the order
    print_order(3);

    return 0;
}