//GEMINI-pro DATASET v1.0 Category: Color Code Converter ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Declare a struct to represent a color
typedef struct {
    unsigned char red;
    unsigned char green;
    unsigned char blue;
} Color;

// Declare a function to convert a hex string to a color
Color hex_to_color(char *hex_string) {
    Color color;
    // Check if the hex string is valid
    if (strlen(hex_string) != 6) {
        fprintf(stderr, "Invalid hex string: %s\n", hex_string);
        exit(EXIT_FAILURE);
    }
    // Convert the hex string to a color
    sscanf(hex_string, "%02x%02x%02x", &color.red, &color.green, &color.blue);
    return color;
}

// Declare a function to convert a color to a hex string
char *color_to_hex(Color color) {
    char *hex_string = malloc(7);
    sprintf(hex_string, "#%02x%02x%02x", color.red, color.green, color.blue);
    return hex_string;
}

// Declare a function to print a color
void print_color(Color color) {
    printf("Red: %u\nGreen: %u\nBlue: %u\n", color.red, color.green, color.blue);
}

// Declare a function to test the color code converter
void test_color_code_converter() {
    // Convert a hex string to a color
    Color color = hex_to_color("FF0000");
    // Print the color
    print_color(color);
    // Convert the color to a hex string
    char *hex_string = color_to_hex(color);
    // Print the hex string
    printf("Hex string: %s\n", hex_string);
    // Free the allocated memory
    free(hex_string);
}

int main() {
    // Test the color code converter
    test_color_code_converter();
    return 0;
}