//GPT-4o-mini DATASET v1.0 Category: Geometric algorithms ; Style: excited
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Struct for representing a point in 2D space
typedef struct {
    double x;
    double y;
} Point;

// Struct for representing a triangle
typedef struct {
    Point a;
    Point b;
    Point c;
} Triangle;

// Function to calculate the area of the triangle
double triangleArea(Triangle triangle) {
    // Using the shoelace formula
    return fabs((triangle.a.x * (triangle.b.y - triangle.c.y) + 
                  triangle.b.x * (triangle.c.y - triangle.a.y) + 
                  triangle.c.x * (triangle.a.y - triangle.b.y)) / 2.0);
}

// Function to check if a point is inside a triangle
int isPointInsideTriangle(Point pt, Triangle triangle) {
    double A = triangleArea(triangle);
    Triangle t1 = {triangle.a, triangle.b, pt};
    Triangle t2 = {triangle.b, triangle.c, pt};
    Triangle t3 = {triangle.c, triangle.a, pt};
    double A1 = triangleArea(t1);
    double A2 = triangleArea(t2);
    double A3 = triangleArea(t3);
    
    return (A == A1 + A2 + A3);
}

// Function to generate random points and triangles
void generateRandomTriangleAndPoint(Triangle* triangle, Point* point) {
    // Generate random triangle
    triangle->a.x = rand() % 100;
    triangle->a.y = rand() % 100;
    triangle->b.x = rand() % 100;
    triangle->b.y = rand() % 100;
    triangle->c.x = rand() % 100;
    triangle->c.y = rand() % 100;

    // Generate random point
    point->x = rand() % 100;
    point->y = rand() % 100;
}

// Function to display triangle coordinates
void displayTriangle(Triangle triangle) {
    printf("Triangle vertices:\n");
    printf("A(%.2f, %.2f)\n", triangle.a.x, triangle.a.y);
    printf("B(%.2f, %.2f)\n", triangle.b.x, triangle.b.y);
    printf("C(%.2f, %.2f)\n", triangle.c.x, triangle.c.y);
}

// Function to display point coordinates
void displayPoint(Point point) {
    printf("Point P(%.2f, %.2f)\n", point.x, point.y);
}

// Main function to run the program
int main() {
    srand(time(NULL)); // Seed for random number generation
    Triangle triangle;
    Point point;

    // Generate random triangle and point
    generateRandomTriangleAndPoint(&triangle, &point);

    // Display the triangle and point
    displayTriangle(triangle);
    displayPoint(point);

    // Check if the point is inside the triangle
    if (isPointInsideTriangle(point, triangle)) {
        printf("The point P is inside the triangle!\n");
    } else {
        printf("The point P is outside the triangle!\n");
    }

    // Calculate and display the area of the triangle
    double area = triangleArea(triangle);
    printf("The area of the triangle is: %.2f\n", area);
    
    return 0;
}