//Falcon-180B DATASET v1.0 Category: Tic Tac Toe AI ; Style: post-apocalyptic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define BOARD_SIZE 3
#define PLAYER_X 1
#define PLAYER_O 2
#define PLAYER_EMPTY 0
#define WINNING_CONDITIONS {0,1,2, 1,2,0, 2,0,1, 2,1,0}

void print_board(int board[BOARD_SIZE][BOARD_SIZE]) {
    int i, j;
    for(i=0; i<BOARD_SIZE; i++) {
        for(j=0; j<BOARD_SIZE; j++) {
            printf("%d ", board[i][j]);
        }
        printf("\n");
    }
}

int check_win(int board[BOARD_SIZE][BOARD_SIZE]) {
    int i;
    for(i=0; i<BOARD_SIZE; i++) {
        if(board[i][0] == board[i][1] && board[i][1] == board[i][2])
            return PLAYER_X;
        if(board[0][i] == board[1][i] && board[1][i] == board[2][i])
            return PLAYER_O;
    }
    if(board[0][0] == board[1][1] && board[1][1] == board[2][2])
        return PLAYER_X;
    if(board[0][2] == board[1][1] && board[1][1] == board[2][0])
        return PLAYER_O;
    return PLAYER_EMPTY;
}

int main() {
    srand(time(NULL));
    int board[BOARD_SIZE][BOARD_SIZE];
    int player = PLAYER_X;
    int choice;
    int i, j;

    for(i=0; i<BOARD_SIZE; i++) {
        for(j=0; j<BOARD_SIZE; j++) {
            board[i][j] = PLAYER_EMPTY;
        }
    }

    while(player!= PLAYER_EMPTY) {
        system("clear");
        print_board(board);
        printf("Player %d's turn\n", player);
        choice = rand() % BOARD_SIZE;
        i = 0;
        while(board[choice][i]!= PLAYER_EMPTY) {
            choice = rand() % BOARD_SIZE;
            i++;
        }
        board[choice][i] = player;
        player = (player == PLAYER_X)? PLAYER_O : PLAYER_X;
        if(check_win(board) == PLAYER_X) {
            printf("Player X wins!\n");
            break;
        }
        else if(check_win(board) == PLAYER_O) {
            printf("Player O wins!\n");
            break;
        }
    }

    return 0;
}